# SEAL Supplementary Code

## Installation Instructions

**⚠️ WARNING: This package conflicts with PEFT. Do not install both simultaneously.**

To review and run this code, please follow these steps:

1. Navigate to the seal directory:
```bash
cd seal
```

2. Install the SEAL package in development mode:
```bash
pip install -e .
```

**Note**: Installing this package will override PEFT functionality. If you have PEFT installed, it may cause conflicts.

## Code Organization

This repository contains the supplementary code for the SEAL paper, excluding:
- Model weights
- CommonSense evaluation datasets

## Prerequisites

- Python 3.8+
- PyTorch
- Transformers library
- **DO NOT install PEFT** (this package provides its own implementation)

## Contents

- Training scripts for SEAL watermarked fine-tuning
- Watermark extraction and detection utilities
- Fine-tuning and instruction tuning examples
- Evaluation scripts for watermark verification