from prompt.omni_prompt import *
import os
import json
import random
import librosa


AUDIO_ROOT_DIR = "/home/export/base/ycsc_1/1/online1//GRM-Omni/data/testset/benchmark/audio/audio_bench"

def is_longer_than_100s(path: str) -> bool:

    duration = librosa.get_duration(path=path)
    return duration > 100

def audiobench_reader(suffix):

    assert suffix in ["audio_und", "audio_gen"]
    benchmark_suffix_file = os.path.join(AUDIO_ROOT_DIR, f"{suffix}.jsonl")

    with open(benchmark_suffix_file, 'r') as f:
        for line in f:
            json_item = json.loads(line)

            if is_longer_than_100s(json_item['audios'][0]):
                continue
            elif len(json_item['audios']) == 2 and is_longer_than_100s(json_item['audios'][1]):
                continue
            
            yield json_item

def load_audiobench_iter(suffix=""):
    
    if suffix == "":
        for suffix in ["audio_und", "audio_gen"]:
            for item in load_audiobench_suffix_iter(suffix):
                yield item
    else:
        for item in load_audiobench_suffix_iter(suffix):
            yield item

def load_audiobench_suffix_iter(suffix):

    if suffix == "audio_gen":
        
        print(f"[Construct Audio Bench, Audio Generation] Suffix:[{suffix}] ")
        for json_item in audiobench_reader(suffix):
            
            chosen_audio = json_item['audios'][0]
            rejected_audio = json_item['audios'][1]
            
            if random.random() > 0.5:
                prefix_pm, inffix_pm, suffix_pm = build_omni_prompt_triple(json_item['prompt'], json_item['chosen'], json_item['rejected'])
                answer = 0
            else:
                prefix_pm, inffix_pm, suffix_pm = build_omni_prompt_triple(json_item['prompt'], json_item['rejected'], json_item['chosen'])
                answer = 1

            conversation = [
                {
                    'role': 'user', 
                    'content': [
                        {"type": "text", "text": prefix_pm},
                        {
                            "type": "audio",
                            "audio": chosen_audio if answer == 0 else rejected_audio,
                        },
                        {"type": "text", "text": inffix_pm},
                        {
                            "type": "audio",
                            "audio": rejected_audio if answer == 0 else chosen_audio,
                        },
                        {"type": "text", "text": suffix_pm}
                    ]
                }
            ]
            yield {
                "suffix": suffix,
                "conversation": conversation, 
                "answer": answer
            }
    elif suffix == "audio_und":

        print(f"[Construct Audio Bench, Audio Understanding] Suffix:[{suffix}] ")
        for json_item in audiobench_reader(suffix):
            
            if random.random() > 0.5:
                prefix_pm, suffix_pm = build_omni_prompt_split(json_item['prompt'], json_item['chosen'], json_item['rejected'])
                answer = 0
            else:
                prefix_pm, suffix_pm = build_omni_prompt_split(json_item['prompt'], json_item['rejected'], json_item['chosen'])
                answer = 1

            conversation = [
                {
                    'role': 'user',
                    'content': [
                        {"type": "text", "text": prefix_pm},
                        {
                            "type": "audio",
                            "audio": json_item['audios'][0]
                        },
                        {"type": "text", "text": suffix_pm}
                    ]
                }
            ]
            yield {
                "suffix": suffix,
                "conversation": conversation, 
                "answer": answer
            }
    else:
        raise Exception(f"Not Support Suffix {suffix} for AudioBench.")
    

