import os
import json
import random


VIDEO_ROOT_DIR = "/home/export/base/ycsc_1/1/online1//GRM-Omni/data/testset/benchmark/language/rewardbench"


def genai_video_reader(suffix):
    
    assert suffix in ["video_gen"]
    benchmark_suffix_file = os.path.join(VIDEO_ROOT_DIR, "video_gen.jsonl")
    with open(benchmark_suffix_file, 'r') as f:
        for line in f:
            yield json.loads(line)

def load_genai_video_iter(build_prompt, suffix=""):
    assert suffix == ""
    suffix = "video_gen"
    return load_genai_video_suffix_iter(suffix, build_prompt)


def load_genai_video_suffix_iter(suffix, build_prompt):

    print(f"[Construct GenAI Bench, Video Generation] Suffix:[{suffix}] ")
    answer = 0
    for json_item in genai_video_reader(suffix):
        
        chosen_video = json_item['videos'][0]
        rejected_video = json_item['videos'][1]

        if random.random() > 0.5:
            prefix_pm, inffix_pm, suffix_pm = build_prompt(json_item['prompt'], json_item['chosen'], json_item['rejected'])
            answer = 0
        else:
            prefix_pm, inffix_pm, suffix_pm = build_prompt(json_item['prompt'], json_item['rejected'], json_item['chosen'])
            answer = 1
        
        conversation = [
            {
                'role': 'user', 
                'content': [
                    {"type": "text", "text": prefix_pm},
                    {
                        "type": "video",
                        "video": chosen_video if answer == 0 else rejected_video,
                        "min_pixels": 256 * 256,
                        "max_pixels": 256 * 256,
                        "total_pixels": 24 * 256 * 256,
                    },
                    {"type": "text", "text": inffix_pm},
                    {
                        "type": "video",
                        "video": rejected_video if answer == 0 else chosen_video,
                        "min_pixels": 256 * 256,
                        "max_pixels": 256 * 256,
                        "total_pixels": 24 * 256 * 256,
                    },
                    {"type": "text", "text": suffix_pm}
                ]
            }
        ]
        yield {
            "suffix": suffix,
            "conversation": conversation, 
            "answer": answer
        }

