import os
import json
import random


ROOT_DIR = "data/benchmark/language/reward_bench"

def rewardbench_reader_iter(benchmark_dir, suffix):
    
    assert suffix in ["chat", "chat_hard", "safety", "reasoning"]
    if benchmark_dir is not None:
        benchmark_suffix_file = os.path.join(benchmark_dir, f"{suffix}.jsonl")
    else:
        benchmark_suffix_file = os.path.join(ROOT_DIR, f"{suffix}.jsonl")
    with open(benchmark_suffix_file, 'r') as f:
        for line in f:
            yield json.loads(line)

def load_rewardbench_iter(build_prompt, benchmark_dir=None, suffix="", skip_critique_suffix={}, criteria=None):
    
    results = {}
    if suffix == "":
        for suffix in ["chat", "chat_hard", "safety", "reasoning"]:
            for item in load_rewardbench_suffix_iter(benchmark_dir, suffix, build_prompt, skip_critique_suffix, criteria):
                yield item
    else:
        return load_rewardbench_suffix_iter(benchmark_dir, suffix, build_prompt, skip_critique_suffix, criteria)
    
    return None

def load_rewardbench_suffix_iter(benchmark_dir, suffix, build_prompt, skip_critique_suffix, criteria=None):
    
    print(f"[Construct Rewardbench] Suffix:[{suffix}] ")
    answer = 0
    for json_item in rewardbench_reader_iter(benchmark_dir, suffix):

        if json_item['suffix'] in skip_critique_suffix:
            continue
        
        if random.random() > 0.5:
            if criteria is not None:
                prompt = build_prompt(json_item['conversations'][0]["content"], json_item['chosen']["content"], json_item['rejected']["content"], criteria)
            else: 
                prompt = build_prompt(json_item['conversations'][0]["content"], json_item['chosen']["content"], json_item['rejected']["content"])
            answer = 0
        else:
            if criteria is not None:
                prompt = build_prompt(json_item['conversations'][0]["content"], json_item['rejected']["content"], json_item['chosen']["content"], criteria)
            else:
                prompt = build_prompt(json_item['conversations'][0]["content"], json_item['rejected']["content"], json_item['chosen']["content"])
            answer = 1
        
        conversation = [{'role': 'user', 'content': prompt},]
        yield {
            "suffix": suffix,
            "_suffix": json_item['suffix'],
            "conversation": conversation, 
            "answer": answer
        }

    return None

def load_rewardbench_judge_iter(build_prompt, benchmark_dir=None, suffix="", skip_suffix={}, suffix2criteria={}):
    
    results = {}
    if suffix == "":
        for suffix in ["chat", "chat_hard", "safety", "reasoning"]:
            for item in load_rewardbench_suffix_judge_iter(benchmark_dir, suffix, build_prompt, skip_suffix, suffix2criteria):
                yield item
    else:
        return load_rewardbench_suffix_judge_iter(benchmark_dir, suffix, build_prompt, skip_suffix, suffix2criteria)
    
    return None

def load_rewardbench_suffix_judge_iter(benchmark_dir, suffix, build_prompt, skip_suffix, suffix2criteria):
    
    print(f"[Construct Rewardbench] Suffix:[{suffix}] ")
    answer = 0
    for json_item in rewardbench_reader_iter(benchmark_dir, suffix):

        if json_item['suffix'] in skip_suffix:
            continue
        
        criteria_list = suffix2criteria[json_item['suffix']]
        criteria = "<criteria 1>{c1}</criteria 1>\n<criteria 2>{c2}</criteria 2>\n<criteria 3>{c3}</criteria 3>".format(c1=criteria_list[0],c2=criteria_list[1],c3=criteria_list[2])

        if random.random() > 0.5:
            prompt = build_prompt(json_item['conversations'][0]["content"], json_item['chosen']["content"], json_item['rejected']["content"], criteria)
            answer = 0
        else:
            prompt = build_prompt(json_item['conversations'][0]["content"], json_item['rejected']["content"], json_item['chosen']["content"], criteria)
            answer = 1
    
        conversation = [{'role': 'user', 'content': prompt},]
        
        yield {
            "suffix": suffix,
            "_suffix": json_item['suffix'],
            "conversation": conversation, 
            "answer": answer
        }

    return None