import os
import json
import random


ROOT_DIR = "/home/export/base/ycsc_1/1/online1//GRM-Omni-v1/dataset/testing/benchmark/image/vl_rewardbench"

def vl_rewardbench_reader_iter(suffix):
    
    assert suffix in ["general", "hallucination", "reasoning"]
    benchmark_suffix_file = os.path.join(ROOT_DIR, f"{suffix}.jsonl")
    with open(benchmark_suffix_file, 'r') as f:
        for line in f:
            yield json.loads(line)

def load_vl_rewardbench_iter(build_prompt, suffix=""):
    
    if suffix == "":
        for suffix in ["general", "hallucination", "reasoning"]:
            for item in load_vl_rewardbench_suffix_iter(suffix, build_prompt):
                yield item
    else:
        return load_vl_rewardbench_suffix_iter(suffix, build_prompt)

def load_vl_rewardbench_suffix_iter(suffix, build_prompt):

    print(f"[Construct VL Rewardbench] Suffix:[{suffix}] ")
    answer = 0
    for json_item in vl_rewardbench_reader_iter(suffix):
        if "prompt" in json_item:
            if random.random() > 0.5:
                prefix_pm, suffix_pm = build_prompt(json_item['prompt'], json_item['chosen'], json_item['rejected'])
                answer = 0
            else:
                prefix_pm, suffix_pm = build_prompt(json_item['prompt'], json_item['rejected'], json_item['chosen'])
                answer = 1
        else:
            if random.random() > 0.5:
                prefix_pm, suffix_pm = build_prompt(json_item['conversations'][0]['content'], json_item['chosen']['content'], json_item['rejected']['content'])
                answer = 0
            else:
                prefix_pm, suffix_pm = build_prompt(json_item['conversations'][0]['content'], json_item['rejected']['content'], json_item['chosen']['content'])
                answer = 1
        assert len(json_item['images']) == 1
        conversation = [
            {
                'role': 'user', 
                'content': [
                    {"type": "text", "text": prefix_pm},
                    {
                        "type": "image", 
                        "image": json_item['images'][0],
                        "min_pixels": 512 * 512,
                        "max_pixels": 512 * 512,
                    },
                    {"type": "text", "text": suffix_pm}
                ]
            }
        ]
        yield {
            "suffix": suffix,
            "conversation": conversation, 
            "answer": answer
        }
