from dataloader.bench_dataloader import BenchmarkDataLoader
from .evaluator import BaseEvaluator
from generator.meta_reward import MetaRewardGenerator
import threading
import time
import json
import os
import re


class PairwiseEvaluator(MetaRewardGenerator, BaseEvaluator):

    def __init__(self, args):
        MetaRewardGenerator.__init__(self,args )
        BaseEvaluator.__init__(self,args )

        self.dataset_loader = BenchmarkDataLoader(self.args)

    def run(self, router):

        start_time = time.time()
        if self.manner == "direct":
            self.direct_judge(router)
        else:
            raise ValueError(f"manner: {self.manner} is not supported")

        end_time = time.time()
        elapsed = end_time - start_time
        print(f"==>⏱️ PairwiseEvaluator router.run() Spend Time: {elapsed:.2f} 秒")

    def run_with_router(self, router, dataset_iter):
        router.add_handler(self.eval_hander)
        router.add_handler(self.json_handler)
        router.run(dataset_iter)
        router.reset_handler()

    def direct_judge(self, router):
        
        for step in range(self.criteria_step):

            dataset_iter = self.dataset_loader.load_iter(self.output_file, self.manner)

            if dataset_iter is not None:
                router.init_inference_model()
                self.run_with_router(router, dataset_iter)

        self.save()
