from abc import ABC, abstractmethod
import os


class BaseGenerator(ABC):

    def __init__(self, args):
        self.args = args

        self.input_file = self.args.input_file
        self.output_dir = self.args.output_dir
        if not os.path.exists(self.output_dir):
            os.makedirs(self.output_dir, exist_ok=True)

    @abstractmethod
    def run(self):
        pass
    
    def init_ray_if_needed(self, **kwargs):
        if not ray.is_initialized():
            print("[INFO] Ray not initialized. Initializing now...")
            ray.init(**kwargs)
        else:
            print("[INFO] Ray already initialized. Skipping ray.init().")

