import re

def clean(prompt, subject):
    prefix = prompt[:prompt.find(subject)]
    while '.' in prefix:
        prefix = prefix[prefix.find('.') + 1:]
    while '\n' in prefix:
        prefix = prefix[prefix.find('\n') + 1:]
    new_prompt = (prefix + prompt[prompt.find(subject):]).strip()
    if 'Category' in new_prompt:
        new_prompt = new_prompt[new_prompt.find(subject):]
    return new_prompt

def get_nested_property(obj, property_path):
    keys = re.split(r'\.|\[|\]', property_path)
    keys = [key for key in keys if key]
    for key in keys:
        if key.isdigit():
            obj = obj[int(key)]
        else:
            obj = getattr(obj, key)
    return obj

def split_array(arr, num_sub_arrays=1):
    n = len(arr)
    sub_array_size = n // num_sub_arrays
    remainder = n % num_sub_arrays
    
    sub_arrays = []
    start = 0
    
    for i in range(num_sub_arrays):
        # If there is a remainder, distribute one more element to this sub-array
        current_size = sub_array_size + (1 if i < remainder else 0)
        sub_arrays.append(arr[start:start + current_size])
        start += current_size
    
    return sub_arrays