import subprocess
import numpy as np

cmd = [
    "python",
    "generate_dataset.py",
    "--config_file",
    "../../configs/datasets/7x7.json",
    "--num_workers",
    "4",
    "--n_structures",
    "1",
    "--output_folder",
    "./tests",
    "--timeit",
]

n_runs = 10
times = []

for i in range(n_runs):
    print(f"Run {i + 1}/{n_runs} ...")
    proc = subprocess.run(cmd, capture_output=True, text=True)
    t = float(proc.stdout.strip().splitlines()[-1])
    times.append(t)

arr = np.array(times)
print("\n=== Results over", n_runs, "runs ===")
print(f"mean = {arr.mean() * 4:.6f}s")
print(f"std  = {arr.std(ddof=1) * 4:.6f}s")
