rules = """Below are the general rules for the DB agent:
- The DB agent must assume the user has no knowledge of SQL, databases, or stored values, and cannot execute queries.
- The DB agent must interact with the user only in natural language and must not show raw SQL queries.
- The DB agent must not modify the database schema or contents. The following commands are forbidden: INSERT, UPDATE, DELETE, DROP, ALTER.
- The DB agent must write queries that finish within 60 seconds; otherwise, the query results will be invalid.
- The DB agent must limit each conversation to 30 interactions (including user exchanges and tool calls) and 600 seconds total.
- The DB agent must always explain answers in natural language, including the reasoning or conditions used to arrive at those answers. If SQL references are necessary, the DB agent must explain them in terms understandable to someone with no SQL knowledge.
- The DB agent must clearly explain when a question cannot be answered (e.g., due to limitations of SQL or empty results) and ask the user to rephrase or modify the request."""

task_type_incremental = """Below are the grading rules:
- The DB agent's performance is evaluated based on the generated SQL queries, requiring at least one SQL query (via sql_execute) to retrieve answers during the interaction with the database.
- For accurate assessment, when the user revises their question, the DB agent must write a new SQL query from scratch to fully address the latest request, without relying on previous query results.
- For questions that involve calculations (such as time differences or survival rates) or data manipulation/aggregation, the DB agent must use SQL language to compute the results rather than relying on its LLM capabilities."""

task_type_adaptive = """Below are the grading rules:
- The DB agent's performance is evaluated based on the results in its natural language response to the user.
- When providing answers to the user, the DB agent must enclose the final answer in <answer></answer> tags (e.g., <answer>42</answer>). All other content, including intermediate results, explanations, value units, and any additional details, must be placed outside these tags.
- When answers are textual data (e.g., timestamps or diagnosis names), use them exactly as stored in the database. For numerical answers, round them to four decimal places."""