export CUDA_VISIBLE_DEVICES=0
export PYTHONPATH=$(pwd)
export EVAL_DIR="cosmos"
export OUTPUT_ROOT="cosmos"

window_size=(1 2 4)
frame_size=(1 2 4 8)
accelerate_algo=("both")  # Or use ("image") depending on the use case
model_name=("Cosmos-1.0-Autoregressive-12B" "Cosmos-1.0-Autoregressive-4B")

# Iterate over window sizes
for ws in "${window_size[@]}"; do
  # Iterate over accelerate algorithms
  for algo in "${accelerate_algo[@]}"; do
    # Iterate over model names
    for model in "${model_name[@]}"; do
      # Iterate over frame sizes
      for fs in "${frame_size[@]}"; do
        # Construct the output path including frame size
        output_path="$OUTPUT_ROOT/${model}_${algo}_${ws}_${fs}"
        mkdir -p $output_path
        
        # Run the inference script
        python cosmos1/models/autoregressive/inference/base.py \
          --window_size=$ws \
          --accelerate_algo=$algo \
          --input_type=video \
          --input_image_or_video_path=$EVAL_DIR \
          --video_save_folder=$output_path \
          --ar_model_dir=$model \
          --frame_size=$fs \
          --top_p=0.8 \
          --temperature=1.0 \
          --disable_diffusion_decoder
      done
    done
  done
done
