function [A] = radon_forward(K,n,xd,yd,xu,yu,theta)
    % K = number of parallel rays per illumination angle
    % theta = equally spaced illumination angles

    M = size(theta,2);
    
    % Set up parallel-beam geometry
    s = -1 + 2/(K-1) * (0:K-1); 
    
    % tomography matrix A in sparse format
    I = []; J = []; val = []; 
    for m = 1:M 
       cc = cos(theta(m)); ss = sin(theta(m)); 
       for k = 1:K 
           if abs(cc) < eps 
               aux = (yd <= s(k)) .* (s(k) < yu); 
               I = [I,((m-1)*K+k)*ones(1,sum(aux))]; 
               J = [J,find(aux)]; 
               val = [val,xu(find(aux))-xd(find(aux))];
           elseif abs(ss) < eps 
               aux = (xd < s(k)) .* (s(k) <= xu);
               I = [I,((m-1)*K+k)*ones(1,sum(aux))];
               J = [J,find(aux)];
               val = [val,yu(find(aux))-yd(find(aux))];
           elseif cc > 0 
               tmp = min((xu-s(k)*cc)/ss,(s(k)*ss-yd)/cc)-max((xd-s(k)*cc)/ss,...
                   (s(k)*ss-yu)/cc); 
               aux = tmp > 0; 
               I = [I,((m-1)*K+k)*ones(1,sum(aux))];
               J = [J,find(aux)];
               val = [val,tmp(aux)];
           elseif cc < 0 
               tmp = min((xu-s(k)*cc)/ss,(s(k)*ss-yu)/cc)-max((xd-s(k)*cc)/ss,...
                   (s(k)*ss-yd)/cc); 
               aux = tmp > 0; 
               I = [I,((m-1)*K+k)*ones(1,sum(aux))];
               J = [J,find(aux)];
               val = [val,tmp(aux)];
           end
       end
    end
    
    A = sparse(I,J,val,M*K,n^2); 

end