import argparse


def get_parser():
    parser = argparse.ArgumentParser()
    parser.add_argument('--hid_dim', type=int, default=512)
    parser.add_argument('--feat_dim', type=int)
    parser.add_argument('--layer', type=int, default=3)
    parser.add_argument('--batch', type=int, default=80)
    parser.add_argument('--patience', type=int, default=50)
    parser.add_argument('--lr', type=float, default=1e-4)
    parser.add_argument('--temperature', type=float, default=0.8)
    parser.add_argument('--n_hops', type=int, default=2)
    parser.add_argument('--ratio', type=float, default=0.9)
    parser.add_argument('--dropout', type=float, default=.3)
    parser.add_argument('--device', type=str, default='cuda')
    parser.add_argument('--verbose', type=bool, default=True)
    parser.add_argument('--random', type=bool, default=False)
    parser.add_argument('--name', type=str, default='Pubmed',
                        choices=['Wiki-CS', 'Amazon-Computers', 'Amazon-Photo',
                                 'Coauthor-CS', 'Coauthor-Physics', 'Cora', 'Pubmed'])
    return parser.parse_args()

