


#!/bin/bash



PYTHONPATH='.':$PYTHONPATH \
PYTHONPATH='./OpenEDL':$PYTHONPATH \


python main.py \
    --config configs/datasets/cifar10/cifar10_train_test_ood.yml \
    configs/preprocessors/base_preprocessor.yml \
    configs/networks/resnet18_32x32.yml \
    configs/pipelines/train/train_edl.yml \
    configs/postprocessors/edl.yml \
    --save_embedding_interval 100 \
    --optimizer.num_epochs 100 \
    --trainer.trainer_args.mixup True \
    --trainer.trainer_args.mix_alpha 10 \
    --trainer.trainer_args.mix_beta 10 \
    --trainer.trainer_args.mix_noise True \
    --trainer.trainer_args.noise_mix_alpha 1 \
    --trainer.trainer_args.noise_mix_beta 1 \
    --optimizer.name sgd \
    --optimizer.lr 0.1 \
    --trainer.trainer_args.loss_fn edl_cross_entropy_loss \
    --trainer.trainer_args.evi_fn softplus \
    --trainer.trainer_args.prior_fn 1.0 \
    --seed 0 \
    --pipeline.name train_test \
    --merge_option merge
