# Environment Setup
## Install
```bash 
cd OpenOOD
conda create -n edl python=3.10
# install torch and torchvision
pip install torch==1.13.1+cu117 torchvision==0.14.1+cu117 torchaudio==0.13.1 --extra-index-url https://download.pytorch.org/whl/cu117
pip install -r requirements.txt
```
## Install EDL related package
```bash
cd EDL
python setup.py develop
```
# Prepare Dataset
1. Download the dataset for OOD detection, including CIFAR-10, CIFAR-100, SVHN, TinyImageNet, MNIST, Texture, and Place365. You can use the following command to download the datasets:
```bash
pip install gdown
sh ./scripts/download/download.sh
```
2. Download the [CIFAR-10-C](https://zenodo.org/record/2535967) and [CIFAR-100-C](https://zenodo.org/record/3555552), unzip them and place them in the `data` folder. The directory structure should look like this:
```bash
mkdir -p data/images_corrupted
tar -xvf CIFAR-10-C.tar -C data/images_corrupted
tar -xvf CIFAR-100-C.tar -C data/images_corrupted 
```
3. Convert to CIFAR-10-C and CIAFR-100-C to OpenOOD dataset format:
```bash
python scripts/corrupted_converter.py
```

## Train and Test
```bash
cd OpenOOD
sh ./scripts/ood/vedl/train_test_cifar10_edl.sh
sh ./scripts/ood/vedl/train_test_cifar100_edl.sh
```
results will be saved to `OpenOOD/results`
