

#!/bin/bash

envname=("ant" "halfcheetah" "hopper" "walker2d")
types=("medium-replay" "medium-expert" "medium" "expert")
seeds=(0 1 2 3 4 5)
methods=("fourier" "forward"  "contrastive" "bpr" "None")

for seed in ${seeds[@]}
do
  for env in ${envname[@]}
  do
    for typ in ${types[@]}
    do
        for method in ${methods[@]}
        do
            echo "#!/bin/bash" >> temprun.sh
            echo "#SBATCH --job-name=bpr-rl_repr" >> temprun.sh
            echo "#SBATCH --cpus-per-task=4"  >> temprun.sh   # ask for 4 CPUs
            echo "#SBATCH --gres=gpu:1" >> temprun.sh         # ask for 2 GPU
            echo "#SBATCH --mem=48G" >> temprun.sh            # ask for 32 GB RAM
            echo "#SBATCH --time=12:00:00" >> temprun.sh
            echo "#SBATCH --output=\"rl_repr/slurm-%j.out\"" >> temprun.sh
            echo "source ~/vd4rl/bin/activate" >> temprun.sh
            echo "export PYTHONPATH=xxxx/rl_repr/" >> temprun.sh
            #sleep 2
            echo "MUJOCO_GL="egl" python -m rl_repr.batch_rl.train_eval_offline --downstream_mode offline --algo_name=brac --task_name "${env}-${typ}-v0" --embed_learner ${method}   --state_action_embed_dim 256 --state_action_fourier_dim 256 --state_embed_dim 256  --embed_training_window 2 --embed_pretraining_steps 100_000 --bc_pretraining_steps 100_000 --alsologtostderr --seed ${seed}">> temprun.sh

            eval "sbatch temprun.sh"
            rm temprun.sh
        done
    done
  done
done