# 📘 Submission Code

This repository contains four main modules related to our work.
Each subfolder includes its own `README.md` file with detailed instructions.
This top-level README provides an overview and explains the relationships between modules.

---

## 📂 Directory Structure

- **`GMoE/`**
  Contains code and documentation for **Image Classification Task - Domainbed Benchmark**.
  - Depends on utilities from `our_tutel/`.
  - See details in [`GMoE/README.md`](GMoE/README.md).

- **`Language-Glue/`**
  Contains the implementation of **Langue-Glue**, a framework for language-related tasks.
  - Also relies on shared components from `our_tutel/`.
  - See details in [`Language-Glue/README.md`](Langue-Glue/README.md).

- **`LanguageModeling/`**
  Contains code for experiments and models related to **Language Modeling**.
  - Works independently and does not depend on `our_tutel/`.
  - See details in [`LanguageModeling/README.md`](LanguageModeling/README.md).

- **`our_tutel/`**
  A shared utility library used by:
  - `GMoE/`
  - `Language-Glue/`
  This is the **core reusable component** across projects.
  - See details in [`our_tutel/README.md`](our_tutel/README.md).

---

## 🚀 Getting Started

1. Check the `README.md` file inside each subfolder for installation and usage instructions.
2. Install the environment requirements as specified per module.
3. For running `GMoE` or `Language-Glue`, ensure that `our_tutel` is properly set up.

---
