# import sys  
# from contextlib import contextmanager  
# from io import StringIO  
# import pandas as pd  
  
# @contextmanager  
# def capture_output():  
#     new_out, new_err = StringIO(), StringIO()  
#     old_out, old_err = sys.stdout, sys.stderr  
#     try:  
#         sys.stdout, sys.stderr = new_out, new_err  
#         yield new_out, new_err  
#     finally:  
#         sys.stdout, sys.stderr = old_out, old_err  
  
# def exec_table(code, table_path):  
#     # Replace the placeholder in the code string with the actual table path  
#     code = code.replace("[[table_path]]", f"'{table_path}'") 
  
#     # Use the custom context manager to capture output and errors  
#     with capture_output() as (out, err):  
#         # Execute the modified code  
#         exec(code)  
      
#     # Get the content from both buffers  
#     result_output = out.getvalue()  
#     result_errors = err.getvalue()  
      
#     # Close the buffers  
#     out.close()  
#     err.close()  
      
#     # Return the captured output and errors  
#     return result_output, result_errors  
import sys    
from contextlib import contextmanager    
from io import StringIO    
import pandas as pd    
    
@contextmanager    
def capture_output():    
    new_out, new_err = StringIO(), StringIO()    
    old_out, old_err = sys.stdout, sys.stderr    
    try:    
        sys.stdout, sys.stderr = new_out, new_err    
        yield new_out, new_err    
    finally:    
        sys.stdout, sys.stderr = old_out, old_err    
    
def exec_table(code, table_path):    
    # Replace the placeholder in the code string with the actual table path    
    code = code.replace("[[table_path]]", f"'{table_path}'")   
    
    # Use the custom context manager to capture output and errors    
    with capture_output() as (out, err):    
        try:  
            # Execute the modified code    
            exec(code)    
        except Exception as e:  
            # Write any exceptions to the err buffer  
            err.write(f"Error executing code: {e}\n")  
        
    # Get the content from both buffers    
    result_output = out.getvalue()    
    result_errors = err.getvalue()    
        
    # Close the buffers    
    out.close()    
    err.close()    
        
    # Return the captured output and errors    
    return result_output, result_errors  
