#configure for test model
mode_name="" # slm
deployment_name=""

batch_size=10
temperature=0.0
slm_max_tokens=512
top_p=1.0
num_gpus=1
# data:
data_path="/data/wikitq/test_1000.jsonl"
tagged_dataset_path="/WikiTableQuestions/tagged/data"
query_dataset_path="/output/wikitq/gpt-4o-phi-3-mini/trad_pos_case_study_correct.jsonl"
rag_file_path_1="/output/wikitq/phi-3-record/phi-3-mini/rag_knn_3_sug.jsonl"
result_path_1_mg="/output/wikitq/phi-3-record/phi-3-mini/rag_mg.jsonl"

retrieval_model=""
device="cuda"


result_path_phi3_mini="/output/wikitq/phi-3-record/phi-3-mini/baseline/first_code.jsonl"
result_path_phi3_mini_execution="/output/wikitq/phi-3-record/phi-3-mini/baseline/execution.jsonl"
result_path_phi3_mini_answer="/output/wikitq/phi-3-record/phi-3-mini/baseline/answer.jsonl"
result_path_phi3_mini_feedback="/output/wikitq/phi-3-record/phi-3-mini/baseline/feedback.jsonl"




echo "starting ${deployment_name} for baseline code evaluation in wikitq in turn 1"
python /src/first_code_gpu.py --prompt_path ${data_path} --deployment_name ${deployment_name} --result_path ${result_path_phi3_mini} --batch_size ${batch_size} \
--temperature ${temperature} --max_tokens ${slm_max_tokens} --top_p ${top_p} --dataset "wikitq" --which_gpu "0"

echo "starting ${deployment_name} for first code execution in wikitq test 1k"
python /src/exec_python.py  --prompt_path ${result_path_phi3_mini} --result_path ${result_path_phi3_mini_execution} --dataset "wikitq" --eval_mode "baseline" \

echo "starting ${deployment_name} for question answering in wikitq test 1k"
python /src/answer_gpu.py --prompt_path ${result_path_phi3_mini_execution} --deployment_name ${deployment_name} --result_path ${result_path_phi3_mini_answer} --batch_size ${batch_size} \
--temperature ${temperature} --max_tokens 20 --top_p ${top_p} --dataset "wikitq" --which_gpu "0" \

echo "starting ${deployment_name} for evaluation in wikitq test 1k"
python /src/wikitq_eval_expl.py --prediction_path ${result_path_phi3_mini_answer} --tagged_dataset_path ${tagged_dataset_path} --output_file_path ${result_path_phi3_mini_feedback}



# =========================== pos al 



result_path_phi3_mini_mg="/output/wikitq/phi-3-record/phi-3-mini/rag_mg.jsonl"
result_path_phi3_mini_cot_pos="/output/wikitq/phi-3-record/phi-3-mini/rag_final_cot_mg.jsonl"
result_path_phi3_mini_code_pos="/output/wikitq/phi-3-record/phi-3-mini/rag_final_code_mg.jsonl"
result_path_phi3_mini_execution_pos="/output/wikitq/phi-3-record/phi-3-mini/rag_final_exec_mg.jsonl"
result_path_phi3_mini_answer_pos="/output/wikitq/phi-3-record/phi-3-mini/rag_final_answer_mg.jsonl"
result_path_phi3_mini_feedback_pos="/output/wikitq/phi-3-record/phi-3-mini/rag_final_feedback_mg.jsonl"

result_path_phi3_mini_mg="/output/wikitq/phi-3-record/phi-3-mini/rag_mg.jsonl"
result_path_phi3_mini_cot_pos="/output/wikitq/phi-3-record/phi-3-mini/rag_final_cot_few.jsonl"
result_path_phi3_mini_code_pos="/output/wikitq/phi-3-record/phi-3-mini/rag_final_code_few.jsonl"
result_path_phi3_mini_execution_pos="/output/wikitq/phi-3-record/phi-3-mini/rag_final_exec_few.jsonl"
result_path_phi3_mini_answer_pos="/output/wikitq/phi-3-record/phi-3-mini/rag_final_answer_few.jsonl"
result_path_phi3_mini_feedback_pos="/output/wikitq/phi-3-record/phi-3-mini/rag_final_feedback_few.jsonl"

python /src/rag_python.py --checkpoint ${retrieval_model} --device ${device} --data_dataset_path ${data_path} --query_dataset_path ${query_dataset_path} \
--output_file_path ${rag_file_path_1}

echo "starting ${deployment_name} for COT generation in wikitq in turn 1"
python /src/rag_mg_gpu.py --prompt_path ${rag_file_path_1} --deployment_name ${deployment_name} --result_path ${result_path_phi3_mini_mg} --batch_size ${batch_size} \
--temperature ${temperature} --max_tokens 512 --top_p ${top_p} --dataset "wikitq" --which_gpu "0"

echo "starting ${deployment_name} for COT generation in wikitq in turn 1"
python /src/rag_final_python_cot_gpu.py --prompt_path ${data_path} --deployment_name ${deployment_name} --result_path ${result_path_phi3_mini_cot_pos} --batch_size ${batch_size} \
--temperature ${temperature} --max_tokens 512 --top_p ${top_p} --dataset "wikitq" --which_gpu "4" \

echo "starting ${deployment_name} for COT code generation in wikitq in turn 1"
python /src/rag_final_python_gpu.py --prompt_path ${result_path_phi3_mini_cot_pos} --deployment_name ${deployment_name} --result_path ${result_path_phi3_mini_code_pos} --batch_size ${batch_size} \
--temperature ${temperature} --max_tokens ${slm_max_tokens} --top_p ${top_p} --dataset "wikitq" --which_gpu "4" \

echo "starting ${deployment_name} for first code execution in wikitq test 1k"
python /src/exec_python.py  --prompt_path ${result_path_phi3_mini_code_pos} --result_path ${result_path_phi3_mini_execution_pos} --dataset "wikitq" --eval_mode "inference" \

echo "starting ${deployment_name} for question answering in wikitq test 1k"
python /src/answer_gpu.py --prompt_path ${result_path_phi3_mini_execution_pos} --deployment_name ${deployment_name} --result_path ${result_path_phi3_mini_answer_pos} --batch_size ${batch_size} \
--temperature ${temperature} --max_tokens 20 --top_p ${top_p} --dataset "wikitq" --which_gpu "4" \

echo "starting ${deployment_name} for evaluation in wikitq test 1k"
python /src/wikitq_eval_expl.py --prediction_path ${result_path_phi3_mini_answer_pos} --tagged_dataset_path ${tagged_dataset_path} --output_file_path ${result_path_phi3_mini_feedback_pos}
