#Note: The openai-python library support for Azure OpenAI is in preview.
import os
import openai
from openai import AzureOpenAI  
import time
import pdb

def get_chat_response_azure(client, model, messages, temperature, max_tokens, top_p, frequency_penalty, presence_penalty, stop=None, max_retries=10):  
    attempt = 0  
    #pdb.set_trace()
    while attempt < max_retries:  
        try:  
            # Create the chat completion request  
            response = client.chat.completions.create(  
                model=model,  
                messages=messages,  
                temperature=temperature,  
                max_tokens=max_tokens,  
                top_p=top_p,  
                frequency_penalty=frequency_penalty,  
                presence_penalty=presence_penalty,  
                stop=stop  
            )  
              
            # Return the response content  
            return response.choices[0].message.content  
  
        except Exception as e:  
            attempt += 1  
            error_message = str(e)
            if "400" in str(error_message) and "repetitive patterns" in error_message:
                return None  # Return None to skip this entry
            print(f"Attempt {attempt} failed: {e}")  
            if attempt < max_retries:  
                time.sleep(10)  # Wait for 2 seconds before retrying  
            else:  
                return f"Failed after {max_retries} attempts: {e}" 

def get_vision_response_azure(client, model, messages, temperature, max_tokens, top_p, frequency_penalty, presence_penalty, stop=None, max_retries=10):  
    attempt = 0  
    #pdb.set_trace()
    while attempt < max_retries:  
        try:  
            # Create the chat completion request  
            response = client.chat.completions.create(  
                model=model,  
                messages=messages,  
                temperature=temperature,  
                max_tokens=max_tokens,  
                top_p=top_p,  
                frequency_penalty=frequency_penalty,  
                presence_penalty=presence_penalty,  
                stop=stop  
            )  
              
            # Return the response content  
            return response.choices[0].message.content  
  
        except Exception as e:  
            attempt += 1  
            print(f"Attempt {attempt} failed: {e}")  
            if attempt < max_retries:  
                time.sleep(10)  # Wait for 2 seconds before retrying  
            else:  
                return f"Failed after {max_retries} attempts: {e}" 


def openai_api_call(model, message, temp, max_tokens, top_p, frequency_penalty, presence_penalth, stop):
    '''It usually is deployed by openai'''
    try:
      response = openai.ChatCompletion.create(engine=model, message=message, temperature=temp, max_tokens=max_tokens, top_p=top_p, 
                                            frequency_penalty=frequency_penalty, presence_penalth=presence_penalth, stop=stop)
      result = response["choices"][0]["message"]["content"]
    except Exception as e:
      result = 'error: {}'.format(e)
    return result

