#!/usr/bin/env python
# -*- coding: utf-8 -*-
import os  
import sys
sys.path.append(os.path.dirname(os.path.dirname(os.path.abspath(__file__))))  
import argparse  
import json  
from openai import AzureOpenAI  
from tqdm import tqdm  
import pdb  
import re  
from transformers import AutoTokenizer
from vllm import LLM, SamplingParams
import torch
  
# Update the import statements to use absolute imports  
from concurrent.futures import ThreadPoolExecutor, as_completed  
from model_api_call import get_chat_response_azure  
from functools import partial  
import sqlite3
import pandas as pd
import gc
import json
from concurrent.futures import ThreadPoolExecutor
from tqdm import tqdm
from sql_utils import extract_meta_guideline

def process_batch_data(data, batch_size):
    # Assuming process_batch_data is a custom function to split data into batches
    return [data[i:i + batch_size] for i in range(0, len(data), batch_size)]


def load_and_infer_from_jsonl_dataset_al(prompt_path, result_path, model_name, prompt_template, temperature=0.0, max_tokens=60, top_p=1, frequency_penalty=0, presence_penalty=0, stop=None, max_retries=10, batch_size=20, min_batch_size=4, num_gpus=1):
    """
    Load prompts from a .jsonl file, get responses using Azure OpenAI in parallel, and save the results in another .jsonl file with progress monitoring.
    This function keeps all original items from the input JSON lines and adds the response, along with indexing each processed line for better tracking.
    """
    
    with open(prompt_path, 'r') as f:
        dataset = [json.loads(line) for line in f]
        # dataset = [wrap_up_code_ins_prompt(data, data['rag_few_shot_prompt'], prompt_suggestions) for data in dataset]
        batch_data = process_batch_data(dataset, batch_size=batch_size)
        
    llm = LLM(model=model_name, max_model_len=16000, gpu_memory_utilization=0.9, trust_remote_code=True, tensor_parallel_size=num_gpus)  # Use the model's max input len
    stop_tokens = None  # should be a list
    tokenizer = AutoTokenizer.from_pretrained(model_name, trust_remote_code=True)
    
    sampling_params = SamplingParams(
        temperature=temperature,
        top_p=top_p,
        max_tokens=max_tokens,
        stop=None,
        stop_token_ids=[tokenizer.eos_token_id]
    )
    
    with open(result_path, 'w', encoding='utf-8') as f:
        for idx, batch_sample in enumerate(tqdm(batch_data)):
            print(f'Infering {idx}th batch...', flush=True)
            with torch.no_grad():
                batch_sample_prompt_list = [batch['rag_prompt'] for batch in batch_sample]
                completions = llm.generate(batch_sample_prompt_list, sampling_params)
                for j, completion in enumerate(completions):
                    data_w = batch_data[idx][j]
                    mg = extract_meta_guideline("```successful plan suggestions:\n1. You should" + completion.outputs[0].text)  # or the correct field name
                    # pdb.set_trace()
                    if mg:
                        data_w['rag_mg'] = mg
                    else:
                        data_w['rag_mg'] = ''
                    f.write(json.dumps(data_w, ensure_ascii=False) + '\n')
            # if idx == 4: pdb.set_trace()
            # pdb.set_trace()
            torch.cuda.empty_cache()
            gc.collect()
                       
def inference():  
    parser = argparse.ArgumentParser(description='Call OpenAI API with specified parameters and configurations.')  
    parser.add_argument('--deployment_name', type=str, required=True, help='Model name to use for the API call.')  
    parser.add_argument('--temperature', type=float, default=0.0, help='Temperature for the response. Default is 0.0.')  
    parser.add_argument('--max_tokens', type=int, default=60, help='Maximum number of tokens to generate. Default is 60.')  
    parser.add_argument('--top_p', type=float, default=1, help='Top P value. Default is 1.')  
    parser.add_argument('--frequency_penalty', type=float, default=0, help='Frequency penalty. Default is 0.')  
    parser.add_argument('--presence_penalty', type=float, default=0, help='Presence penalty. Default is 0.')  
    parser.add_argument('--stop', nargs='*', help='Stop sequence(s). Multiple values are allowed.')  
    parser.add_argument('--prompt_path', type=str, required=True, help='Path to the input .jsonl file containing prompts.')  
    parser.add_argument('--result_path', type=str, required=True, help='Path where the output .jsonl file with results will be saved.')  
    parser.add_argument('--batch_size', type=int, required=False, help='if your API could be run in parallel')
    parser.add_argument('--dataset', type=str, required=True, help='dataset name')
    parser.add_argument('--which_gpu', type=str, required=False, default='0', help='No.gpu')
      
    args = parser.parse_args()  
    os.environ["CUDA_VISIBLE_DEVICES"] = args.which_gpu
      
    args = parser.parse_args()  
    
    if args.dataset == "bird":
        from prompts.bird_prompt_combine.prompt.bird_all import rag_phi_prompt_v1
    
    prompt_template = None
    
    load_and_infer_from_jsonl_dataset_al(args.prompt_path, args.result_path, model_name=args.deployment_name, prompt_template=prompt_template, temperature=args.temperature, max_tokens=args.max_tokens,  
                                top_p=args.top_p, stop=args.stop, batch_size=args.batch_size, num_gpus=1)
      
  
if __name__ == "__main__":  
    inference()  
