#!/usr/bin/env python
# -*- coding: utf-8 -*-
import os  
import sys
sys.path.append(os.path.dirname(os.path.dirname(os.path.abspath(__file__))))  
import re

import sqlparse
from sqlparse.sql import Identifier, IdentifierList, Parenthesis
from sqlparse.tokens import Keyword, DML

def extract_function_code(result):  
    pattern = r"```code_plan\n(.*?)(?:\n```|\n#n```)"  
    python_re = re.search(pattern, result, re.DOTALL)  
    if python_re:  
        code = python_re.group(1)  # Use group(1) directly  
        return code  
    else:  
        return ''  


def mask_sub_sqls(sql_plan):
    def is_subquery(parsed):
        if not parsed.is_group:
            return False
        for item in parsed.tokens:
            if item.ttype is DML and item.value.upper() == 'SELECT':
                return True
        return False

    def mask_tokens(tokens):
        for token in tokens:
            if isinstance(token, Parenthesis):
                if is_subquery(token):
                    token.tokens = [sqlparse.sql.Token(None, '([[FILL YOUR SQL]])')]
                else:
                    mask_tokens(token.tokens)
            elif isinstance(token, IdentifierList):
                mask_tokens(token.tokens)
            elif isinstance(token, Identifier):
                mask_tokens(token.tokens)

    parsed = sqlparse.parse(sql_plan)
    for stmt in parsed:
        mask_tokens(stmt.tokens)

    return ''.join(str(stmt) for stmt in parsed)

def extract_sqlite(result):  
    pattern = r"```sqlite\n(.*?)(?:\n```|\n#n```)"  
    python_re = re.search(pattern, result, re.DOTALL)  
    if python_re:  
        code = python_re.group(1)  # Use group(1) directly  
        return code  
    else:  
        return ''
    

def extract_function_sql(result):  
    pattern = r"```sqlite_plan\n(.*?)(?:\n```|\n#n```)"  
    python_re = re.search(pattern, result, re.DOTALL)  
    if python_re:  
        code = python_re.group(1)  # Use group(1) directly  
        return code  
    else:  
        return ''  


def extract_action_tags(text):
    """
    Extracts content within <action> tags from the provided text.

    Parameters:
    text (str): The text to search within.

    Returns:
    list: A list of strings found within <action> tags.
    """
    # Regex pattern to extract content within <action> tags
    pattern = r'<action>(.*?)</action>'
    
    # Extracting the content
    matches = re.findall(pattern, text)
    
    return matches


def extract_meta_guideline(result):  
    pattern = r"```successful plan suggestions:\n(.*?)(?:\n```|\n#n```)"  
    python_re = re.search(pattern, result, re.DOTALL)  
    if python_re:  
        code = python_re.group(1)  # Use group(1) directly  
        return code  
    else:  
        return ''
    
def extract_sqlite_plan(result):  
    pattern = r"```sqlite_plan\n(.*?)(?:\n```|\n#n```)"  
    python_re = re.search(pattern, result, re.DOTALL)  
    if python_re:  
        code = python_re.group(1)  # Use group(1) directly  
        return code  
    else:  
        return ''   