import json
import argparse
import pdb

def compute_average_score(jsonl_file_path):
    total_score = 0
    count = 0
    
    # Mapping from letter grades to numerical scores
    score_mapping = {
        "A": 1,
        "B": 0.5,
        "F": 0
    }
    
    with open(jsonl_file_path, 'r') as file:
        for line in file:
            data = json.loads(line)
            score = data.get("eval_score")
            
            # Only process if score is not None, not an empty string, and is in the mapping
            if score is not None and score != "" and score in score_mapping:
                total_score += score_mapping[score]
                count += 1
    
    if count == 0:
        return 0, 0, 0  # Return zeros if there are no valid scores
    average_score = (total_score / count) * 100
    # pdb.set_trace()
    return average_score, total_score, count

def main():
    parser = argparse.ArgumentParser(description="Compute the average score from a JSONL file.")
    parser.add_argument('--eval_file_path', type=str, help="Path to the JSONL file")
    
    args = parser.parse_args()
    
    average_score, total_score, count = compute_average_score(args.eval_file_path)
    print(f"Total Num: {count}")
    print(f"Total Score: {total_score}")
    print(f"Average Score: {average_score:.2f}")

if __name__ == "__main__":
    main()
