/*
  Name:     aldr.h
  Purpose:  Fast sampling of random integers.
  Author:   CMU Probabilistic Computing Systems Lab
  Copyright (C) 2025 CMU Probabilistic Computing Systems Lab, All Rights Reserved.

  Released under Apache 2.0; refer to LICENSE.txt
*/

#ifndef ALDR_H
#define ALDR_H

#include <stdint.h>
#include <stdlib.h>

// array
struct array_s
{
    size_t length;
    uint64_t *a;
};

// flattened ALDR tree
struct aldr_flat_s
{
    uint64_t length_breadths;
    uint64_t length_leaves_flat;
    uint64_t *breadths;
    uint64_t *leaves_flat;
};

void free_aldr_flat_s (struct aldr_flat_s *x);
void free_array_s (struct array_s *x);
struct aldr_flat_s *preprocess_aldr_flat(uint64_t* a, size_t n);
struct aldr_flat_s *preprocess_fldr_flat(uint64_t* a, size_t n);
struct array_s *preprocess_aldr_enc(uint64_t* a, size_t n);
struct array_s *preprocess_fldr_enc(uint64_t* a, size_t n);
uint64_t sample_aldr_flat(struct aldr_flat_s* f);
uint64_t sample_aldr_enc(struct array_s* x);
uint64_t bytes_sample_aldr_flat(struct aldr_flat_s *x);
uint64_t bytes_array(struct array_s *x);

#endif
