/*
  Name:     alias.h
  Purpose:  Exact weighted alias method, translated from Rust to C.
  Author:   CMU Probabilistic Computing Systems Lab
  Copyright (C) 2025 CMU Probabilistic Computing Systems Lab, All Rights Reserved.
            And An Anonymous Lab
  Released under Apache 2.0; refer to LICENSE.txt
*/

#ifndef ALIAS_H
#define ALIAS_H

#include <stdint.h>

// weighted alias index arrays
struct sample_weighted_alias_index_s {
    uint64_t length;
    uint64_t weight_sum;
    uint64_t *aliases;
    uint64_t *no_alias_odds;
};

void free_sample_weighted_alias_index(struct sample_weighted_alias_index_s *x);
struct sample_weighted_alias_index_s *preprocess_weighted_alias(uint64_t* a, size_t n);
uint64_t sample_weighted_alias_index(struct sample_weighted_alias_index_s *x);
int bytes_sample_weighted_alias_index(struct sample_weighted_alias_index_s *x);

#endif
