/*
  Name:     flip.h
  Purpose:  Generating a sequence of pseudo-random bits.
  Author:   CMU Probabilistic Computing Systems Lab
  Copyright (C) 2025 CMU Probabilistic Computing Systems Lab, All Rights Reserved.
            And An Anonymous Lab
  Released under Apache 2.0; refer to LICENSE.txt
*/

#ifndef FLIP_H
#define FLIP_H

#include <stdint.h>
#include <stddef.h>

typedef uint64_t flip_t;
#define FLIP_T_MAX UINT64_MAX

extern size_t flip_k;
extern flip_t flip_word;
extern size_t flip_pos;
extern uint64_t NUM_RNG_CALLS;

extern flip_t flip(void);
extern flip_t flip_n(flip_t n);
extern flip_t uniform(flip_t n);
extern flip_t bernoulli(flip_t numer, flip_t denom);

// Macros for min and max.
#define max(a, b)            \
({                           \
    __typeof__ (a) _a = (a); \
    __typeof__ (b) _b = (b); \
    _a > _b ? _a : _b;       \
})

#define min(a, b)            \
({                           \
    __typeof__ (a) _a = (a); \
    __typeof__ (b) _b = (b); \
    _a < _b ? _a : _b;       \
})

#endif
