/*
  Name:     sample.c
  Purpose:  Command line interface for aldr.
  Author:   CMU Probabilistic Computing Systems Lab
  Copyright (C) 2025 CMU Probabilistic Computing Systems Lab, All Rights Reserved.

  Released under Apache 2.0; refer to LICENSE.txt
*/

#include <stdio.h>
#include <stdlib.h>

#include "aldr.h"

#include <inttypes.h>

int main(int argc, char **argv) {
    if (argc < 3) {
        printf("usage: %s <num_samples> <distribution>\n", argv[0]);
        exit(0);
    }
    size_t num_samples = strtoul(argv[1], NULL, 10);

    // Parse the distribution.
    size_t n = (size_t)argc - 2;
    uint64_t *a = calloc(n, sizeof(*a));
    for (size_t i = 0; i < n; ++i) {
        a[i] = strtoul(argv[i + 2], NULL, 10);
    }

    // Obtain the samples.
    struct aldr_flat_s *x = preprocess_aldr_flat(a, n);
    for (size_t i = 0; i < num_samples; ++i) {
        printf("%"PRIu64, sample_aldr_flat(x));
    }
    printf("\n");

    // Free the heap.
    free(a);
    free_aldr_flat_s(x);

    return 0;
}
