import matplotlib.pyplot as plt
import pickle


plt.style.use("paper.mplstyle")

PT = 1.0 / 72.27  # 72.27 points to an inch.
GOLDEN_RATIO = (1 + 5**0.5) / 2
IMAGE_WIDTH = 239.39438 * PT

LEGEND_FONTSIZE = 10

colors = ["#e16f00", "dodgerblue"]

with open("data/trueskill_distributions.pickle", "rb") as handle:
    results = pickle.load(handle)

fig, axs = plt.subplots(1, 2, figsize=(IMAGE_WIDTH, IMAGE_WIDTH / GOLDEN_RATIO))
axs[1].hist(
    [results["skill1"], results["skill2"]],
    weights=[results["weights"], results["weights"]],
    bins=50,
    color=colors,
)
labels = [r"$p(s_1 | R)$", r"$p(s_2| R)$"]
for i, label in enumerate(labels):
    axs[1].text(
        1,
        1.05 - i * 0.1,
        label,
        color=colors[i],
        fontsize=LEGEND_FONTSIZE,
        transform=axs[1].transAxes,
        ha="center",
    )
axs[1].get_yaxis().set_visible(False)

axs[0].hist(
    [results["skill1"], results["skill2"]],
    bins=50,
    color=colors,
)
labels = [r"$p(s_1)$", r"$p(s_2)$"]
for i, label in enumerate(labels):
    axs[0].text(
        1,
        1.05 - i * 0.1,
        label,
        color=colors[i],
        fontsize=LEGEND_FONTSIZE,
        transform=axs[0].transAxes,
        ha="center",
    )
axs[0].get_yaxis().set_visible(False)
plt.tight_layout()
plt.savefig(
    "figures/pdf_trueskill_skills.pdf", format="pdf", dpi=600, bbox_inches="tight"
)
plt.show()


fig, axs = plt.subplots(
    1, 2, figsize=(IMAGE_WIDTH, IMAGE_WIDTH / GOLDEN_RATIO), width_ratios=[5, 5]
)
axs[1].hist(
    [results["performance1"], results["performance2"]],
    weights=[results["weights"], results["weights"]],
    bins=50,
    color=colors,
)

labels = label = [r"$p(y_1 | R)$", r"$p(y_2 | R)$"]
for i, label in enumerate(labels):
    axs[1].text(
        1,
        1.05 - i * 0.1,
        label,
        color=colors[i],
        fontsize=LEGEND_FONTSIZE,
        transform=axs[1].transAxes,
        ha="center",
    )
axs[1].get_yaxis().set_visible(False)

axs[0].hist(
    [results["performance1"], results["performance2"]],
    bins=50,
    color=colors,
)

labels = [r"$p(y_1)$", r"$p(y_2)$"]
for i, label in enumerate(labels):
    axs[0].text(
        1,
        1.05 - i * 0.1,
        label,
        color=colors[i],
        fontsize=LEGEND_FONTSIZE,
        transform=axs[0].transAxes,
        ha="center",
    )
axs[0].get_yaxis().set_visible(False)


plt.tight_layout()
plt.savefig(
    "figures/pdf_trueskill_performances.pdf", format="pdf", dpi=600, bbox_inches="tight"
)
