#ifndef ALGORITHM_CLUT_H
#define ALGORITHM_CLUT_H

#include <stddef.h>
#include <stdint.h>

typedef struct clut_context {
    size_t r;
    size_t c;
    uint64_t* cLUT;
    size_t cLUT_size;
    size_t cLUT_linelen;
} clut_context_t;

extern clut_context_t *build_cLUT(uint64_t *counts, size_t counts_size);
extern uint64_t cLUT_sampling(clut_context_t *ctx);

extern void free_cLUT(clut_context_t *ctx);

#endif