#ifndef ALGORITHMS_NLUT_H
#define ALGORITHMS_NLUT_H

#include <stddef.h>
#include <stdint.h>

#include <flip.h>

typedef struct nlut_context {
    uint64_t n_or_nbits;
    uint64_t *nLUT;
    size_t nLUT_size;
    flip_t (*flip_func)(flip_t n_or_nbits);
} nlut_context_t;


extern nlut_context_t *build_nLUT(uint64_t *repeats, size_t N);
extern uint64_t nLUT_sampling(nlut_context_t *ctx);

extern void free_nLUT(nlut_context_t *ctx);

#endif
