#ifndef NUMPY_SAMPLING_H
#define NUMPY_SAMPLING_H

#include <stddef.h>

typedef struct numpy_context {
    double *cdf;
    size_t len;
    float start;
    float step;
} numpy_context_t;

extern numpy_context_t *build_numpy(uint64_t *counts, size_t counts_size);
extern float numpy_sampling(numpy_context_t *ctx);
extern void free_numpy(numpy_context_t *ctx);

#endif