#include "dist_loader.h"

#include <stdlib.h>
#include <stdio.h>

#include <inttypes.h>


distribution_t *load_distribution(const char *path)
{
    #define die_on_fscanf(msg) do { fprintf(stderr, "unexpected content in %s found at %s:%d, exiting ...\n", path, __FILE__, __LINE__); exit(2); } while (0);

    FILE *fp = fopen(path, "r");
    if (!fp)
        return 0;

    distribution_t *dist = malloc(sizeof(distribution_t));

    if (fscanf(fp, "%"SCNd64, &dist->Z) != 1) {die_on_fscanf();}
    if (fscanf(fp, "%zu", &dist->n) != 1) {die_on_fscanf();}
    dist->array = calloc(dist->n, sizeof(*(dist->array)));
    for (size_t i = 0; i < dist->n; ++i) {
        if (fscanf(fp, "%"SCNd64, &dist->array[i]) != 1) {die_on_fscanf();}
    }
    if (fscanf(fp, "%f", &dist->H) != 1) {die_on_fscanf();}
    fclose(fp);

    return dist;
}

void free_distribution(distribution_t *dist)
{
	free(dist->array);
    free(dist);
}