/*
  Name:     macros.c
  Purpose:  Macro for preprocessing and timing a sampler.
  Author:   CMU Probabilistic Computing Systems Lab
  Copyright (C) 2025 CMU Probabilistic Computing Systems Lab, All Rights Reserved.

  Released under Apache 2.0; refer to LICENSE.txt
*/

#ifndef LUT_MACROS_H
#define LUT_MACROS_H

#include "ns.h"

#define READ_PREPROCESS_SAMPLE_TIME(key, \
        var_sampler, \
        context_type, \
        func_preprocess, \
        func_post_experiment_action, \
        func_sample, \
        func_free, \
        measure_memory_flag, \
        var_array, \
        var_n, \
        var_sample_steps, \
        var_preprocess_steps, \
        var_preprocess_time_cold, \
        var_preprocess_time_warm, \
        var_post_experiment_dst, \
        var_sample_time, \
        var_preprocess_energy_cold, \
        var_preprocess_energy_warm, \
        var_sample_energy, \
        var_energy_len, \
        var_x) \
    if(strcmp(var_sampler, key) == 0) { \
        do { \
            var_energy_len = measure_memory_flag ? 0 : rapl_start(); \
            var_preprocess_energy_cold = malloc(sizeof(double) * var_energy_len); \
            var_preprocess_time_cold = ns(); \
            context_type *s = func_preprocess(var_array, var_n); \
            var_preprocess_time_cold = ns() - var_preprocess_time_cold; \
            if (measure_memory_flag) { \
                break; \
            } \
            rapl_end_read(var_preprocess_energy_cold, var_energy_len); \
            var_energy_len = rapl_start(); \
            var_preprocess_energy_warm = malloc(sizeof(double) * var_energy_len); \
            var_preprocess_time_warm = ns(); \
            for (int i = 0; i < var_preprocess_steps; i++) { \
                func_free(s); \
                s = func_preprocess(var_array, var_n); \
            } \
            var_preprocess_time_warm = ns() - var_preprocess_time_warm; \
            rapl_end_read(var_preprocess_energy_warm, var_energy_len); \
            var_energy_len = rapl_start(); \
            var_sample_energy = malloc(sizeof(double) * var_energy_len); \
            var_sample_time = ns(); \
            for (int i = 0; i < var_sample_steps; i++) { \
                var_x += func_sample(s); \
            } \
            var_sample_time = ns() - var_sample_time; \
            rapl_end_read(var_sample_energy, var_energy_len); \
            var_post_experiment_dst = func_post_experiment_action((context_type *)s); \
            func_free(s); \
        } while (0);\
    }

#endif 