#ifndef RAPL_H
#define RAPL_H

#include <stdio.h>
#include <inttypes.h>

#ifndef REPORT_RAPL_TICKS
#define REPORT_RAPL_TICKS 0
#endif

#if REPORT_RAPL_TICKS
typedef uint64_t rapl_dst_t; // Report ticks (1/scale-th of a joule)
#   define RAPL_DST_FMT PRIu64
#else 
typedef double rapl_dst_t; // Report joules
#   define RAPL_DST_FMT "g"
#endif

extern int rapl_setup(void);

extern void rapl_print_domains(FILE *fd, const char *prefix);

extern size_t rapl_start(void);
extern size_t rapl_end_read(rapl_dst_t *dst, size_t max_count);

extern int rapl_end_print(void);

#endif