import pandas as pd
import itertools
import numpy as np

one = 1
milli = 1e3
micro = 1e6
nano = 1e9
sampling_runs = 1000000
preprocess_runs = 10


def do_transforms(df):
	df['sample-energy-pkg-0'] = df['sample-energy-pkg-0']  / sampling_runs
	df['preprocess_warm-energy-pkg-0'] = df['preprocess_warm-energy-pkg-0']  / preprocess_runs

	df['sample-power-pkg-0'] = df['sample-energy-pkg-0'] / df['sample_time'] 
	df['preprocess-power-pkg-0'] = df['preprocess_warm-energy-pkg-0'] / df['preprocess_time_warm']

	df['sample_time'] = df['sample_time'] * nano
	df['sample-energy-pkg-0'] = df['sample-energy-pkg-0'] * nano
	df['preprocess_warm-energy-pkg-0'] = df['preprocess_warm-energy-pkg-0'] * one
	return df


def do_run(df):
	print(type(df['preprocess_time_warm'].values[0]))
	df = do_transforms(df)
	grouped = df.groupby("sampler").agg(
		sample_energy_pkg_mean=("sample-energy-pkg-0", "mean"),
		sample_energy_pkg_std=("sample-energy-pkg-0", "std"),
		sampling_time_mean=("sample_time", "mean"),
		sampling_time_std=("sample_time", "std"),
		sample_power_pkg_mean=("sample-power-pkg-0", "mean"),
		sample_power_pkg_std=("sample-power-pkg-0", "std"),
		preprocess_energy_pkg_mean=("preprocess_warm-energy-pkg-0", "mean"),
		preprocess_energy_pkg_std=("preprocess_warm-energy-pkg-0", "std"),
		preprocessing_time_mean=("preprocess_time_warm", "mean"),
		preprocessing_time_std=("preprocess_time_warm", "std"),
		preprocess_power_pkg_mean=("preprocess-power-pkg-0", "mean"),
		preprocess_power_pkg_std=("preprocess-power-pkg-0", "std"),
		# count=("sampler", "count")
	).reset_index().round(2)
	print(grouped)

	for s in itertools.combinations(df['sampler'].unique(), 2):
		s1, s2 = s
		print(f'{s1} / {s2}:')
		for stat in ['sample-energy-pkg-0', 'sample_time']:
			t1 = df[df['sampler'] == s1][stat]
			t2 = df[df['sampler'] == s2][stat]
			improvement = np.array(t1.values.astype(float) / t2.values.astype(float))
			print(f'\t{stat}:\t{improvement.mean()} +/- {improvement.std()}')


df = pd.read_csv('data/c_measurements.csv')
do_run(df)

# 2. Group and compute mean/std


print('10^4 to 10^5')
df = pd.read_csv('data/c_measurements.csv')
df = df[df["N"] < 1e5]
do_run(df)


print('10^5 to 10^8')
df = pd.read_csv('data/c_measurements.csv')
df = df[df["N"] >= 1e5]
do_run(df)
