import pandas as pd
import numpy as np

df = pd.read_csv("data/trueskill_results.csv")
print(df.columns)

cols = ["method"]
for x in ["mcp", "rapl:cores", "rapl:pkg", "sampling_runtimes"]:
	cols.append(f"{x}_mean")
	cols.append(f"{x}_std")

df["method"] = df["method"].replace(
	{"baseline_continuous": "baseline", "clut_lut_c_wrapper": "cLUT"}
)

df = df[cols]
df = df.set_index("method")
df.loc["diff"] = (-(df.loc["baseline"] - df.loc["cLUT"]) / df.loc["baseline"]).round(4)
df["mcp"] = df.apply(lambda x: f"{x['mcp_mean']}  {np.round(x['mcp_std'], 2)}", axis=1)
df["rapl:cores"] = df.apply(
	lambda x: f"{x['rapl:cores_mean']}	{np.round(x['rapl:cores_std'], 2)}", axis=1
)
df["rapl:pkg"] = df.apply(
	lambda x: f"{x['rapl:pkg_mean']}	{np.round(x['rapl:pkg_std'], 2)}", axis=1
)
df["sampling_runtimes_mean"] = df["sampling_runtimes_mean"].round(2)
df["sampling_runtimes"] = df.apply(
	lambda x: f"{x['sampling_runtimes_mean']}  {np.round(x['sampling_runtimes_std'], 2)}",
	axis=1,
)


print(df[["mcp", "rapl:cores", "rapl:pkg", "sampling_runtimes"]])
