import pickle
import numpy as np
from scipy.stats import ttest_rel, ranksums, mannwhitneyu, kruskal

def read_results(name):
    with open(name, "rb") as handle:
        file = pickle.load(handle)
    return file

result = read_results("results/trueskill/stat_test.pickle")

print(ttest_rel(
    result[("baseline", "continuous")]["means"], 
    result[("clut", "lut_c_wrapper")]["means"],
    # use_continuity=False
))

print(ttest_rel(
    result[("baseline", "continuous")]["means"], 
    result[("baseline", "discrete")]["means"],
    # use_continuity=False
))

print(ttest_rel(
    result[("clut", "lut_c_wrapper")]["means"], 
    result[("baseline", "discrete")]["means"],
    # use_continuity=False
))


print(ttest_rel(
    result[("baseline", "continuous")]["variances"], 
    result[("clut", "lut_c_wrapper")]["variances"],
    # use_continuity=False
))

print(ttest_rel(
    result[("baseline", "continuous")]["variances"], 
    result[("baseline", "discrete")]["variances"],
    # use_continuity=False
))

print(ttest_rel(
    result[("clut", "lut_c_wrapper")]["variances"], 
    result[("baseline", "discrete")]["variances"],
    # use_continuity=False
))

print(
    np.mean(result[("baseline", "continuous")]["means"]),
    np.mean(result[("baseline", "discrete")]["means"]),
    np.mean(result[("clut", "lut_c_wrapper")]["means"])
)

print(
    np.mean(result[("baseline", "continuous")]["variances"]),
    np.mean(result[("baseline", "discrete")]["variances"]),
    np.mean(result[("clut", "lut_c_wrapper")]["variances"])
)
