# Towards Estimating Transferability using Hard Subsets

This repository includes the code for our paper 'Towards Estimating Transferability using Hard Subsets'. Code is included for 3 main experiments from Section 5 of our paper - 
- Source Architecture Selection
- Ensemble Selection
- Semantic Segmentation

## Usage
### Source Architecture Selection
For computing results from the Source Architecture Selection Experiment (ImageNet Source Models)
```bash
$ python3 collect_activations_imagenet.py --dataset $DATASET_NAME$ #For collecting activations to generate similarity matrix
$ python3 calc_similarity_imagenet.py --dataset $DATASET_NAME$ #For generating similarity matrix for class-agnostic hardness metric
$ python3 get_transfer_accuracies_source_arch_best.py # For computing ground truth transfer accuracies to compute correlation
$ python3 calc_leep_arch.py #For computing base LEEP, NCE 
$ python3 calc_leep_arch_modi.py #For computing class-agnostic version of HASTE modification for LEEP, NCE
$ python3 calc_leep_arch_modi_cs.py #For computing class-specific version of HASTE modification for LEEP, NCE
$ python3 calc_gbc_modi.py #For computing base GBC, and both class-specific and class-agnostic version of HASTE modification for GBC
```

### Semantic Segmentation
For computing results from the Source Architecture Selection Experiment of Semantic Segmentation, specifically for BDD100k
```bash
#repeat the first command twice for every source dataset and model combination
$ python3 collect_activations_pascalvoc.py --dataset-name $DATASET_NAME$ #For collecting activations to generate similarity matrix. Do this once with DATASET_NAME as bdd100k and once with pascalvoc
$ python3 calc_similarity_bdd.py --dataset bdd100k #For generating similarity matrix for class-agnostic hardness metric
$ python3 hleep_bdd.py --dataset bdd100k #For computing base LEEP, base NCE and class-agnostic version of HASTE modification for LEEP, NCE
$ python3 hleep_bdd_GBC.py --dataset bdd100k #For computing base GBC, and class-agnostic version of HASTE modification for GBC
```
