# model
num_classes = 65
tgt_model = dict(type='ResNet', depth=50, num_classes=num_classes)
tgt_head = dict(type='BottleNeckMLP', feature_dim=2048, bottleneck_dim=256, num_classes=num_classes,
                type1='bn', type2='wn')
loss = dict(
    test=dict(type='CrossEntropyLoss'),
)

# data
sample_list_dir = f'./data/office_home'
src, tgt = 'R', 'P'  # A: Art, C: Clipart, P: Product, R: Real_World

batch_size = 64
num_workers = 4
mean = (0.485, 0.456, 0.406)
std = (0.229, 0.224, 0.225)

# training optimizer & scheduler
epochs = 30
lr = 0.01
optimizer = dict(type='SGD', lr=lr, momentum=0.9, weight_decay=1e-3, nesterov=True)

# log & save
log_interval = 100
work_dir = None  # rewritten by args
resume = None
load = f'./checkpoints/office_home/src_{src}/distill_train_tgt_{tgt}/last.pth'
port = 10001
