import numpy as np


def gaussian(x, mu=0., sig=1.):
    return (
        1.0 / (np.sqrt(2.0 * np.pi) * sig) * np.exp(-np.power((x - mu) / sig, 2.0) / 2)
    )

def gaussian_reward(x, mu=(-0.2, 0.2), sig=(0.12, 0.12)):
    g1 = gaussian(x, mu=mu[0], sig=sig[0]) #/ gaussian(mu[0], sig=max(sig))
    g2 = gaussian(x, mu=mu[1], sig=sig[1]) * 0.8 #/ gaussian(mu[1], sig=max(sig))
    reward = np.max(np.stack([g1, g2], axis=1), axis=1) / gaussian(mu[0], mu=mu[0], sig=min(sig))
    return reward


def action_sampler(xs, num_samples=1000, n_max=20):
    if num_samples == 500:
        n_max = 10
    samples = np.array([])
    for x in xs:
        n_samples = int(n_max * np.abs(x))
        new_samples = np.random.uniform(x-0.01, x+0.01, n_samples)
        samples = np.concatenate([samples, new_samples])

    num_rest = num_samples - len(samples)
    if num_rest > 0:
        print(f'Uniformly sample {num_rest} data points')
        samples = np.concatenate([samples, np.random.uniform(-1, 1, num_rest)])
    return np.clip(samples, -1, 1)