
from __future__ import absolute_import, division, print_function

from functools import reduce

import torch
import numpy as np
import random


# -----------------------------------------------------------------------------------------------------------#
# General auxilary functions
# -----------------------------------------------------------------------------------------------------------#
def set_random_seed(seed):
    torch.manual_seed(seed)
    torch.cuda.manual_seed_all(seed)
    np.random.seed(seed%(2**32-1))
    random.seed(seed)

def list_mult(L):
    return reduce(lambda x, y: x*y, L)
