GIF_FILE = "city32_big192_5c2_unetm_long.gif"

import imageio

wid = lambda n : 128*2*n + 2*n + 6*(n+1)
hit = lambda n : 128*n + 6*(n+1)

reader = imageio.get_reader(GIF_FILE)
frames = []
for frame in reader:
    frames.append(frame[:, :])


n_per_row = (frames[0].shape[1] - 6)//264
n_rows = (frames[0].shape[0] - 6)//134
img_wid = 6+128*2+2
img_hit = 6+128

choose = [2, 4, 5, 6, 8, 9, 10, 11, 16, 18, 19, 22, 25, 26, 27, 29, 30, 31, 32, 33, 34, 35, 36, 39, 40, 41, 42, 43, 44, 49, 50, 51, 52, 53, 56]

new_n_per_row = 5
new_n_rows = 7

new_frames = []
for frame in frames[::2]:
    for i in range(new_n_rows):
        for j in range(new_n_per_row):
            num = choose[i*new_n_per_row + j]-1
            left = (num%n_per_row)*img_wid
            top = (num//n_per_row)*img_hit
            image = frame[top:top+img_hit, left:left+img_wid]
            new_row = np.hstack([new_row, image]) if j > 0 else image
        new_row = np.hstack([new_row, frame[0:img_hit, -6:, :]])
        new_frame = np.vstack([new_frame, new_row]) if i > 0 else new_row
    new_frame = np.vstack([new_frame, frame[-6:, 0:new_frame.shape[1], :]])
    new_frames.append(new_frame)

imageio.mimwrite(GIF_FILE.split('.gif')[0] + f"_{new_n_rows}{new_n_per_row}.gif", new_frames)

# ff = []
# for frame in frames:
#     ff.append(frame[:-6-64, :])
