import glob
import numpy as np
import os


def remove_ckpt_files():
    ckpt_files = np.array(sorted(glob.glob("checkpoint_*")))
    ckpt = [int(os.path.splitext(os.path.basename(aa))[0].split('_')[-1]) for aa in ckpt_files]
    s_ckpt = np.sort(ckpt, kind='stable')
    s_ckpt_idx = np.argsort(ckpt, kind='stable')
    s_ckpt_files = ckpt_files[s_ckpt_idx]
    ckpt_keep = s_ckpt[4::5]
    ckpt_keep = np.concatenate([ckpt_keep, [s_ckpt[-1]]])
    for c in range(len(s_ckpt)):
        if s_ckpt[c] not in ckpt_keep:
            os.remove(s_ckpt_files[c])
