import numpy as np
#distance between MDPs
def Mdist(mdp1, mdp2):
    D1 = np.max(np.abs(mdp1.R - mdp2.R))
    D2 = np.max(np.sum(np.abs(mdp1.P - mdp2.P),axis=2))
    return max(D1,D2)

def Odist(omega1,omega2):
    #assert (omega2!=0).all()
    return np.max(np.abs(omega1-omega2)/omega2)

def Pidist(pi1, pi2):
    return np.max(np.abs(pi1-pi2))
    