MULTIPLE_PROMPT = 'You are a helpful assistant, below is a query from a user and some relevant contexts. \
Answer the question given the information in those contexts. Your answer should be short and concise. \
If you cannot find the answer to the question, just say "I don\'t know". \
\n\nContexts: [context] \n\nQuery: [question] \n\nAnswer:'

QUESTION_PROMPT = 'You are a helpful assistant, below is a query from a user. \
Your answer should be short and concise. \
\n\nQuery: [question] \n\nAnswer:'


def wrap_prompt(question, context="[context]", prompt_id=1) -> str:
    if prompt_id == 4:
        assert type(context) == list
        context_str = "\n".join(context)
        input_prompt = MULTIPLE_PROMPT.replace(
            '[question]', question).replace('[context]', context_str)
    elif prompt_id == 0:
        input_prompt = QUESTION_PROMPT.replace('[question]', question)
    else:
        input_prompt = MULTIPLE_PROMPT.replace(
            '[question]', question).replace('[context]', context)
    return input_prompt
