# f-VAT Semi-Supervised Time Series Classification

[![Build Status](https://img.shields.io/badge/build-passing-brightgreen?style=flat-square)](https://github.com/)
[![Python](https://img.shields.io/badge/python-3.8%2B-blue?style=flat-square)](https://www.python.org/)
[![Paper Status](https://img.shields.io/badge/paper-under_review-orange?style=flat-square)](https://github.com/)

**f-VAT** implements a semi-supervised learning framework for time series. The repository accompanies a NeurIPS submission and provides ready-to-run experiments, utilities and visualizations.

## Overview

f-VAT combines temporal convolutional networks with virtual adversarial training for semi-supervised time series classification. A gradually increasing unsupervised loss and an exponential moving average model encourage stable predictions even with few labels.

### Key Contributions
- Support for six UCR-style datasets: `CricketX`, `UWave`, `InsectWing`, `SelfReg`, `NATOPS`, and `Heartbeat`.
- Reproducible training scripts with logging and checkpointing.
- Example NATOPS visualizations in `visualize.ipynb`.

### Quick Start
Install the dependencies and run the provided script on the `CricketX` dataset:

```bash
pip install numpy torch scikit-learn pandas wandb
python mainOurs.py --label_ratio 0.2 --gpu 0 --dataset_name CricketX
```

## Features

- Out-of-the-box support for six datasets: `CricketX`, `UWave`, `InsectWing`, `SelfReg`, `NATOPS` and `Heartbeat`.
- Training logs for `CricketX` under
  [`ratio_0_1.log`](log/ratio_0_1.log) and
  [`ratio_0_2.log`](log/ratio_0_2.log)
- NATOPS visualization via `visualize.ipynb` (see `docs/` for sample outputs)

## Installation

This project requires Python 3 with the packages below:

- `numpy`
- `torch`
- `scikit-learn`
- `pandas`
- `wandb` (optional)

Install them with:

```bash
pip install numpy torch scikit-learn pandas wandb
```

## Quick Start

Reproduce the example run on `CricketX`:

```bash
python mainOurs.py --label_ratio 0.2 --gpu 0 --dataset_name CricketX
```

## Logs and Results

The repository includes sample logs to illustrate typical output. During
training, detailed progress is written to
[`log/ratio_0_1.log`](log/ratio_0_1.log) and
[`log/ratio_0_2.log`](log/ratio_0_2.log), corresponding to runs with 10%
and 20% labeled data. Each log captures per-epoch metrics, timing and
hyper-parameter settings. Additional logs and figures are collected in the
[`docs/`](docs/) directory.

After training finishes, a concise summary is produced under `results/`.

NATOPS visualizations can be explored directly in `visualize.ipynb`.
Sample output figures are stored under [`docs/`](docs/) and the complete set of
saliency maps is provided as PDFs in [`other/`](other/).
The log directory also references complete NATOPS visualizations saved as
[`other/0_1.pdf`](other/0_1.pdf) and [`other/0_4.pdf`](other/0_4.pdf).
These PDFs can be regenerated or inspected interactively via `visualize.ipynb`.

## Code Structure

```
├── dataloader/      # Data loading utilities (UCR .tsv reader, etc.)
├── datasets/        # Included example datasets
├── loader/          # Data sampling and preprocessing helpers
├── model/           # Network architectures and training logic
├── optim/           # Training utilities and early stopping
├── results/         # Experiment outputs
├── log/             # Sample logs (ratio_0_1.log, ratio_0_2.log)
└── visualize.ipynb  # NATOPS visualization notebook
```

### Important Files

- `mainOurs.py` – entry point for training with numerous configuration flags.
- `model/trainer.py` – implements the core f-VAT training loop, including virtual adversarial perturbations and ramp-up schedules.
- `dataloader/TSC_data_loader.py` – reads UCR-format datasets and normalizes values.

## Tips

- Adjust `--label_ratio` to experiment with different amounts of labeled data.
- Logs in the `log/` directory show detailed training progress. The provided
  `ratio_0_1.log` and `ratio_0_2.log` record 10% and 20% label experiments.
- For new datasets, place the `.tsv` files under `datasets/` and modify the
  `--dataset_name` argument accordingly.

## Citation

If you find this repository helpful, please cite the paper once it becomes available.
