# scMoE: single-cell Multi-Modal Multi-Task Learning via Sparse Mixture-of-Experts

<img src="assets/Model.png" width="100%">


## **Environmental Setup (Step-by-step guide to install FastMoE library)**

```
conda create -n scmoe python=3.10 -y
conda activate scmoe
conda install pytorch==2.0.1 torchvision==0.15.2 torchaudio==2.0.2 pytorch-cuda=11.7 -c pytorch -c nvidia -y
conda install nvidia::cudatoolkit conda-forge::cudatoolkit-dev -y
conda install -c conda-forge gxx=10.4 -y
export LD_LIBRARY_PATH=/path_to_anaconda3/scmoe/lib:$LD_LIBRARY_PATH
export CUDA_HOME=/path_to_anaconda3/envs/scmoe
cd src/network
git clone https://github.com/laekov/fastmoe.git 
cd fastmoe 
USE_NCCL=0 python setup.py install
conda install dm-tree scikit-learn tqdm pandas -y
conda install -c conda-forge scanpy nibabel -y
```

## Dataset
* Dataset can be downloaded here: https://zenodo.org/records/7708592


## How to Run

1. Dyngen
```
python ./scripts/train_dyngen.py
```

2. DBiT-seq
```
python ./scripts/train_dbitseq.py
```

3. Patch-seq
```
python ./scripts/train_patchseqy.py
```

4. ATAC-seq
```
python ./scripts/train_atacseq.py
```



