In this folder `chirality_in_action_splits`, we provide all the splits for
the three datasets uses in chiral action recognition.

The description of each split is as follows:

| Split | Description |
|-------|-------------|
| `chiral_groups-combined.csv` | Combined chiral groups for all datasets |
| `chiral_groups-ssv2-train.csv` | Chiral groups for SSv2 train set |
| `chiral_groups-charades-train.csv` | Chiral groups for Charades train set |
| `chiral_groups-epic-train.csv` | Chiral groups for Epic train set |
| `chiral_groups-ssv2-validation.csv` | Chiral groups for SSv2 validation set |
| `chiral_groups-charades-validation.csv` | Chiral groups for Charades validation set |
| `chiral_groups-epic-validation.csv` | Chiral groups for Epic validation set |
| `cia-ssv2-train.csv` | Chiral groups for SSV2 train set |
| `cia-ssv2-validation.csv` | Chiral groups for SSV2 validation set |
| `cia-charades-train.csv` | Chiral groups for Charades train set |
| `cia-charades-validation.csv` | Chiral groups for Charades validation set |
| `cia-epic-train.csv` | Chiral groups for Epic train set |
| `cia-epic-validation.csv` | Chiral groups for Epic validation set |


The splits with prefix `chiral_groups` contain chiral groups: 
(verb positive, verb negative, noun) triplets.
The splits with prefix `cia` contain the train and validation 
splits for each dataset with only the subset of the dataset 
relevant for chiral action recognition.

The chiral group files have the columns:
- `verb_forward`: positive verb
- `verb_reverse`: negative verb
- `noun`: noun object
- `id_forward`: video IDs separated by `;` for positive verb
- `id_reverse`: video IDs separated by `;` for negative verb
- `triplet_id,split`: triplet ID and split (train/validation)

The `cia` split files have two important columns:
- `chiral_label`: this is 1 for a positive verb and 0 for a negative verb
- `chiral_triplet_id`: This denotes the ID for each chiral group (triplet)


