# RULE: Reinforcement Learning Unlearning Environment

RULE is a research framework for training, evaluating, and unlearning language models using reinforcement learning and related techniques. It supports multiple model architectures, flexible experiment configuration, and robust evaluation tools.

## Features

- **Multiple Dataset Support:** Includes MUSE, RWKU.
- **Reinforcement Learning Algorithms:** PPO and other RL methods for language model fine-tuning and unlearning.
- **Dataset Management:** Tools for organizing and processing datasets.
- **Flexible Experiment Configuration:** YAML-based configs for easy experiment setup.
- **Evaluation Utilities:** Scripts for model evaluation and analysis.

## Directory Structure

```
data/           # Datasets and metadata
examples/       # Example experiment configs
verl/           # Core source code (models, training, evaluation, utils)
log/            # Training and evaluation logs
run_muse.sh     # Script to run MUSE experiments
run_rwku.sh     # Script to run RWKU experiments
requirements.txt
setup.py
```

## Getting Started

1. **Install dependencies**
   ```sh
   pip install -r requirements.txt
   ```

2. **Install the package**
   ```sh
   python setup.py install
   ```

3. **Run an experiment**
   ```sh
   bash run_muse.sh
   ```
   Or run a specific config:
   ```sh
   python verl/scripts/train.py --config examples/ppo_rj_rl.yaml
   ```

## Configuration

Edit YAML files in `examples/` to set hyperparameters, dataset paths, and model options.

## Contributing

Contributions are welcome! Please open issues or submit pull requests.

## License

See the `LICENSE` file for details.