
ERASE_ID=std
SAFE_LEVEL=MAX
SD_MODEL_ID=v1-4

ERASE_ID_FULL=std
# Check the value of input_type
if [ "$ERASE_ID" = "esd" ]; then
    config_path="./configs/esd_nudity_optmz_config.json"
    ERASE_ID_FULL=$ERASE_ID
elif [ "$ERASE_ID" = "sld" ]; then
    if [ "$SAFE_LEVEL" = "MAX" ]; then
        config_path="./configs/sldMAX_nudity_optmz_config.json"        
    elif [ "$SAFE_LEVEL" = "STRONG" ]; then
        config_path="./configs/sldSTRONG_nudity_optmz_config.json"
    else
        config_path="na"
    fi
    ERASE_ID_FULL=$ERASE_ID+$SAFE_LEVEL

elif [[ "$ERASE_ID" = "std" ]]; then
    config_path="./configs/ddim50_sd_eval_config.json"
    ERASE_ID_FULL=$ERASE_ID
else
    config_path="na"
fi

if [[ "$SD_MODEL_ID" = "xl" ]]; then
    model_id="stabilityai/stable-diffusion-xl-base-1.0"
elif [ "$SD_MODEL_ID" = "v1-4" ]; then
    model_id="CompVis/stable-diffusion-v1-4"
elif [ "$SD_MODEL_ID" = "v2" ]; then
    model_id="stabilityai/stable-diffusion-2"
else    
    model_id="na"
fi



configs="--config $config_path \
    --nudenet-path ./pretrained/nudenet_classifier_model.onnx \
    --num-samples 1\
    --erase-id $ERASE_ID \
    --safe-level $SAFE_LEVEL \
    --model_id $model_id \
    --save_in_one    \
    --ngpt \
    --tfg \
    --tfg_rescale"
    
echo $configs

for freeu_hyp in 1.0-1.0-0.9-0.2
do
    for artist in 'Van Gogh'
    do
        artist_comp="${artist// /}"
        if [[ "$artist" = "Van Gogh" ]]; then
            csv_data="./references/RECE/dataset/big_artist_prompts.csv"
            art_set="big_artist"
        elif [ "$artist" = "Kelly McKernan" ]; then
            csv_data="./references/RECE/dataset/short_niche_art_prompts.csv"
            art_set="niche_artist"
        else 
            csv_data="na"
            art_set="na_artist"
        fi
        
        tfg_type='mask_to_onp'
        safreeu_style="original"
        safreeu_freq="all"
        alpha="0.01"
        
        if [[ "$tfg_type" = "orth_and_proj" ]]; then
            tfg_type_short="ONP"
        elif [ "$tfg_type" = "mask_to_onp" ]; then
            tfg_type_short="M2O"
        else    
            tfg_type_short=$tfg_type
        fi
        
        alpha_txt=$(echo $alpha | sed 's/\./p/')
        freeu_hyp_txt=$(echo $freeu_hyp | sed 's/\./p/g')

        echo $artist
        echo $tfg_type_short
        echo $alpha_txt
        echo $safreeu_style
        echo $safreeu_freq
        
        beta_type=sigmoid
        
        for bals_up_timestep in 10
        do
            python run_p4d_eval_image.py \
                --data $csv_data \
                --tfg_type $tfg_type \
                --category artists-$artist_comp \
                --save-dir ./results/run_SD${SD_MODEL_ID}_${ERASE_ID_FULL}_artists_${artist_comp}_${art_set}_tfg_alpha_${alpha_txt}_${tfg_type_short}_safreeu_${safreeu_style}_${safreeu_freq}_${freeu_hyp_txt}/ \
                --tfg_alpha ${alpha} \
                --safreeu \
                --safreeu_freq $safreeu_freq \
                --safreeu_style $safreeu_style \
                --freeu_hyp $freeu_hyp \
                --tfg_auto_balance \
                --beta_type ${beta_type} \
                --bals_up_timestep ${bals_up_timestep} \
                $configs
        done
    done
done

